:- if((current_prolog_flag(windows,F),not(F))).
   :- encoding(utf8).
:- endif.

:- set_prolog_flag(double_quotes,string).

%i,i,i,i
xml_gmx(FichierXml,_,Xpixels,Ypixels) :-
   % nettoie base geometrix ventuellement en mmoire
	retractall_graphdat,
% lecture du fichier source xml
	string_to_atom(FichierXml,Fin),
	load_structure(Fin,
		       [element(construction,_,
				[element(elements,_,Liste_elements),
				 element(constraints,_,Liste_contraintes)|_]
			       )
		       ],
		       []),

	retractall(fig_4(_,_,_,_,_,_,_,_,_)),
	catch(cree_objetsgmx(Liste_elements,Liste_contraintes,Xpixels,Ypixels),_,fail),
	fail.
xml_gmx(_,FichierGmx,_,_) :-
	ordonne_indexage,
% catch(sauve_graphdat("c:/essai0.txt"),_,fail),  % <<< pour les tests
% ecriture dans le fichier FichierGmx des relations logiques
	catch(sauve_graphdat(FichierGmx),_,fail),
	fail.
xml_gmx(_,_,_,_).



% i,i,i,i  indderministe
cree_objetsgmx(Liste_elements,Liste_contraintes,Xpixels,Ypixels) :-

  % slectionne 1 elt
  member(element(Type_xml,[Id_Nom],Coordonnees),Liste_elements),

  % typage gomtrix de l'objet
  type_geometrix(Type_xml,Id_Nom,NomAtome,TypeNom_gmx),
  % rcupration des coordonnes (quand ncessaire)
  coordonnees_objet(TypeNom_gmx,Xpixels,Ypixels, Coordonnees,List_coord,VectPosNom),
  % retrouve nom i2g de la contrainte et les constructeurs cods gmx
  proprietes_xml(Type_xml,NomAtome,Liste_contraintes,Type_contrainte,LesFoncteurs),
  % contrainte gomtrie dynamique traduite en relation logique (codage gomtrix)
  contraintexml_codegmx(Type_contrainte,CodeX,CodeY),
  parents_et_constructeurs(CodeX,CodeY,LesFoncteurs,Parents,Constructeurs),

  \+(( TypeNom_gmx=point_f(_),List_coord=[])),
  numerotation_objet(Index),

  % prvention des incohrences logiques dues  l'absence de convention dans la nomination des objets
  corrige_incoherence_i2g(fig_4(TypeNom_gmx,[16777215,0],VectPosNom,"d",List_coord,Parents,"",[Index,CodeX,CodeY],Constructeurs),Pred),
  assert(Pred),

  fail.


% sauvegarde ds un fic tmp la base des objets dfinis dans le fichier i2g
cree_objetsgmx(_,_,_,_) :-
	tmp_file('gmxtmp',Fictmp),
	catch(sauve_graphdat(Fictmp),_,fail),
	retractall_graphdat,
% cette base n'est pas cohrente, il faut la renvoyer au noyau de Gomtrix pour qu'il en fasse une base valide
	raz_base,
	catch(consult(Fictmp),_,fail),
	etablir_num_max(_),
	a_jour_b_plus,
	suppObjEnErreur,
	catch(histoire_des_pdwactions,_,fail),
	delete_file(Fictmp),
	fail.
cree_objetsgmx(_,_,_,_) :-
  fig_4(point_f(A),B,C,D,E,F,G,H,I),
  repositionne_point_sur(fig_4(point_f(A),B,C,D,E,F,G,H,I)),
  fail.


% nom de la contrainte sous xml et liste des constructeurs gmx
% i,i,i,o,o
proprietes_xml(point,Milieu,Lst_contraintes,midpoint_line_segment,LesFoncteurs) :-
	memberchk(element(midpoint_line_segment,_,
			 [element(point,_,[Milieu]), % <- nom du pt milieu
			  element(Type2,_,[Segment])|Args   % <- segment(nom incohrent dans i2g)
			 ]),
		 Lst_contraintes),
	memberchk(element(line_segment_by_points,_,
			 [element(Type2,_,[Segment]),
			  element(_,_,[A]),              % noms des 2 extrmits du segment
			 element(_,_,[B])|Args
			 ]),
		 Lst_contraintes),

        msort([A,B],[A1,B1]),
% 3 args car le 1 est ignor ds "parents_et_constructeurs" en standard
	typenomsxml_foncteurnomsgmx([segment_f(Segment),point_f(A1),point_f(B1)],LesFoncteurs),
	!.

proprietes_xml(point,Milieu,Lst_contraintes,point_on_line_segment,LesFoncteurs) :-
	memberchk(element(point_on_line_segment,_,
			 [element(point,_,[Milieu]), % <- nom du pt milieu
			  element(Type2,_,[Segment])|Args   % <- segment(nom incohrent dans i2g)
			 ]),
		 Lst_contraintes),
	memberchk(element(line_segment_by_points,_,
			 [element(Type2,_,[Segment]),
			  element(_,_,[A]),              % noms des 2 extrmits du segment
			 element(_,_,[B])|Args
			 ]),
		 Lst_contraintes),

        msort([A,B],[A1,B1]),

% 3 args car le 1 est ignor ds "parents_et_constructeurs" en standard
	typenomsxml_foncteurnomsgmx([segment_f(Segment),point_f(A1),point_f(B1)],LesFoncteurs),
	!.


proprietes_xml(point,Milieu,Lst_contraintes,midpoint_of_two_points,LesFoncteurs) :-
	memberchk(element(midpoint_of_two_points,_,
			 [element(point,_,[Milieu]),
			  element(point,_,[A]),
			  element(point,_,[B])|_]),
		 Lst_contraintes),
        msort([A,B],[A1,B1]),
% 3 args car le 1 est ignor ds "parents_et_constructeurs" en standard
	typenomsxml_foncteurnomsgmx([point_f(Milieu),point_f(A1),point_f(B1)],LesFoncteurs),
	!.
proprietes_xml(point,PtSurCrcl,Lst_contraintes,point_on_circle,LesFoncteurs) :-
	memberchk(element(point_on_circle,_,
			 [element(point,_,[PtSurCrcl]),
			  element(circle,_,[Cercle])|_]),
		 Lst_contraintes),
% 3 args car le 1 est ignor ds "parents_et_constructeurs" en standard
	typenomsxml_foncteurnomsgmx([point_f(PtSurCrcl),cercle_f(Cercle)],LesFoncteurs),
	!.

% cercle dfini par 3 pts
proprietes_xml(circle,Cercle,Lst_contraintes,circle_by_three_points,LesFoncteurs) :-
	memberchk(element(circle_by_three_points,_,
			 [element(circle,_,[Cercle]),
			  element(point,_,[P1]),
			  element(point,_,[P2]),
			  element(point,_,[P3])|_]),
		 Lst_contraintes),
        msort([P1,P2,P3],[A1,B1,C1]),
	typenomsxml_foncteurnomsgmx([point_f(A1),point_f(B1),point_f(C1)],LesFoncteurs),
	!.

proprietes_xml(line,Droite,Lst_contraintes,circle_tangent_lines_by_point,LesFoncteurs) :-
	memberchk(element(circle_tangent_lines_by_point,_,
			 [element(line,_,[D1]),
			  element(line,_,[D2]),
			  element(circle,_,[Cercle]),
			  element(point,_,[Point])|_]),
		 Lst_contraintes),
	nth0(Index,[D1,D2],Droite),
	I is Index+1,
	nombre_chaine(I,Ic),
	typenomsxml_foncteurnomsgmx([point_f(Point),cercle_f(Cercle),ch(Ic),droite_f(D1),droite_f(D2)],LesFoncteurs),
	!.

proprietes_xml(line,Biss,Lst_contraintes,line_angular_bisector_of_three_points,LesFoncteurs) :-
	memberchk(element(circle_tangent_lines_by_point,_,
			 [element(line,_,[Biss]),
			  element(point,_,[B]),
			  element(point,_,[A]),
			  element(point,_,[C])|_]),
		 Lst_contraintes),
	msort([B,C],[P1,P3]),
	typenomsxml_foncteurnomsgmx([droite_f(Biss),point_f(P1),point_f(A),point_f(P3)],LesFoncteurs),
	!.
%vecteur 2 pts
proprietes_xml(vector,Vecteur,Lst_contraintes,vector_from_point_to_point,LesFoncteurs) :-
	memberchk(element(vector_from_point_to_point,_,
			 [element(point,_,[P]),
			  element(point,_,[Q]),
			  element(vector,_,[Vecteur])|_]),
		 Lst_contraintes),
	typenomsxml_foncteurnomsgmx([vecteur_f(Vecteur),point_f(P),point_f(Q)],LesFoncteurs),
	!.
%demi droite
proprietes_xml(ray,DemiD,Lst_contraintes,ray_from_point_through_point,LesFoncteurs) :-
	memberchk(element(ray_from_point_through_point,_,
			 [element(point,_,[P]),
			  element(point,_,[Q]),
			  element(ray,_,[DemiD])|_]),
		 Lst_contraintes),

	typenomsxml_foncteurnomsgmx([demidroite_f(DemiD),point_f(P),point_f(Q)],LesFoncteurs),
	!.
proprietes_xml(polygon,NomPoly,Lst_contraintes,polygon_by_vertices,LesFoncteurs) :-
	memberchk(element(polygon_by_vertices,_,
			 [element(polygon,_,[_]),
			  element(list_of_vertices,_,ListeSommets)]),
		 Lst_contraintes),
	findall(Sommet,
		member(element(point,[],[Sommet]),ListeSommets),
		LesPoints),
	applicationFoncteurs(point_f("x"),LesPoints,Sommets_gmx),
%	lst_str(Pts_ch,"",NomPoly),
	typenomsxml_foncteurnomsgmx([polygone_f(NomPoly)|Sommets_gmx],LesFoncteurs),
	!.

% symtrie centrale
proprietes_xml(Type,Image,Lst_contraintes,symmetry_by_point,LesFoncteurs) :-
	memberchk(Type,[point,line_segment ]),
	memberchk(element(symmetry_by_point,_,
			 [element(TypeImage,_,[Image]),
			  element(TypeImage,_,[Antecedant]),
			  element(point,_,[NomCentre])]),
		 Lst_contraintes),
    (	Type=point,
	typenomsxml_foncteurnomsgmx([point_f(Image),point_f(Antecedant),point_f(NomCentre)],LesFoncteurs)
    ;
        Type=line_segment,
	memberchk(element(line_segment_by_points,_,
			 [element(line_segment,_,[Antecedant]),
			  element(point,_,[P1]),
			  element(point,_,[P2])]),
		 Lst_contraintes),
	% faut retrouver les noms des images des points du segment antcdant sur lequel la sym a t applique
	memberchk(element(symmetry_by_point,_,
			 [element(point,_,[ImageP1]),
			  element(point,_,[P1]),
			  element(point,_,[NomCentre])]),
		 Lst_contraintes),
	memberchk(element(symmetry_by_point,_,
			 [element(point,_,[ImageP2]),
			  element(point,_,[P2]),
			  element(point,_,[NomCentre])]),
		 Lst_contraintes),
	typenomsxml_foncteurnomsgmx([point_f(ImageP1),point_f(ImageP1),point_f(ImageP2)],LesFoncteurs)
    ),

	!.
 % symtrie axiale
proprietes_xml(Type,Image,Lst_contraintes,symmetry_by_line,LesFoncteurs) :-
	memberchk(Type,[point,line_segment ]),
	memberchk(element(symmetry_by_line,_,
			 [element(TypeImage,_,[Image]),
			  element(TypeImage,_,[Antecedant]),
			  element(line,_,[NomAxe])]),
		 Lst_contraintes),
    (	Type=point,
	typenomsxml_foncteurnomsgmx([point_f(Image),point_f(Antecedant),droite_f(NomAxe)],LesFoncteurs)
    ;
        Type=line_segment,
	memberchk(element(line_segment_by_points,_,
			 [element(line_segment,_,[Antecedant]),
			  element(point,_,[P1]),
			  element(point,_,[P2])]),
		 Lst_contraintes),
	% faut retrouver les noms des images des points du segment antcdant sur lequel la sym a t applique
	memberchk(element(symmetry_by_line,_,
			 [element(point,_,[ImageP1]),
			  element(point,_,[P1]),
			  element(line,_,[NomAxe])]),
		 Lst_contraintes),
	memberchk(element(symmetry_by_line,_,
			 [element(point,_,[ImageP2]),
			  element(point,_,[P2]),
			  element(line,_,[NomAxe])]),
		 Lst_contraintes),
	typenomsxml_foncteurnomsgmx([point_f(ImageP1),point_f(ImageP1),point_f(ImageP2)],LesFoncteurs)
    ),
	!.
 % translation
proprietes_xml(Type,Image,Lst_contraintes,translate,LesFoncteurs) :-
	memberchk(Type,[point,line_segment ]),
	memberchk(element(translate,_,
			 [element(TypeImage,_,[Image]),
			  element(TypeImage,_,[Antecedant]),
			  element(vector,_,[NomVect])]),
		 Lst_contraintes),
    (	Type=point,
	typenomsxml_foncteurnomsgmx([point_f(Image),point_f(Antecedant),vecteur_f(NomVect)],LesFoncteurs)
    ;
        Type=line_segment,
	memberchk(element(line_segment_by_points,_,
			 [element(line_segment,_,[Antecedant]),
			  element(point,_,[P1]),
			  element(point,_,[P2])]),
		 Lst_contraintes),
	% faut retrouver les noms des images des points du segment antcdant sur lequel la transl a t applique
	memberchk(element(translate,_,
			 [element(point,_,[ImageP1]),
			  element(point,_,[P1]),
			  element(vector,_,[Vecteur])]),
		 Lst_contraintes),
	memberchk(element(translate,_,
			 [element(point,_,[ImageP2]),
			  element(point,_,[P2]),
			  element(vector,_,[Vecteur])]),
		 Lst_contraintes),
	typenomsxml_foncteurnomsgmx([point_f(ImageP1),point_f(ImageP1),point_f(ImageP2)],LesFoncteurs)
    ),

	!.

proprietes_xml(Type2,Nom2,Lst_contraintes,Contrainte_i2g,LesFoncteurs) :-
   % le nom de l'objet peut apparatre en pos 2 (couple pts intersections par ex)
        member(Contrainte_i2g,[intersection_points_of_circle_and_line,intersection_points_of_two_circles]),
	memberchk(element(Contrainte_i2g,_,
			 [element(Type1,_,[Nom1]),
			  element(Type2,_,[Nom2])|Args
			 ]),
		 Lst_contraintes),
   (    Contrainte_i2g= intersection_points_of_circle_and_line,
	!,
	typenomsxml_foncteurnomsgmx([element(Type1,_,[Nom1])|Args],LesFoncteurs)
   ;
	 Contrainte_i2g=intersection_points_of_two_circles,
        typenomsxml_foncteurnomsgmx([point1(Nom1),element(Type2,_,[Nom2])|Args],LesFoncteurs),
	!
   ).

proprietes_xml(Type,Nom,Lst_contraintes,Type_contrainte,LesFoncteurs) :-
       memberchk(element(Type_contrainte,_,[element(Type,_,[Nom])|Args]),Lst_contraintes),
       !,
     % ds Args liste des objets ncessaires  la construction de l'objet Nom.
       typenomsxml_foncteurnomsgmx([element(Type,_,[Nom])|Args],LesFoncteurs).


proprietes_xml(_,_,_,_,[]).


% i,o
typenomsxml_foncteurnomsgmx([],[]):-!.
typenomsxml_foncteurnomsgmx([element(Type,_,[Id_Nom])|Q],[Foncteur|R]) :-
	type_geometrix(Type,Id_Nom,_,Foncteur),
	typenomsxml_foncteurnomsgmx(Q,R).
typenomsxml_foncteurnomsgmx([point1(P1)|Q],[Point1|R]) :-
	type_geometrix(point1,P1,_,Point1),
	typenomsxml_foncteurnomsgmx(Q,R).
typenomsxml_foncteurnomsgmx([Foncteur|Q],[Objet_gmx|R]) :-
	Foncteur =..[F,Arg],
	type_geometrix(F,Arg,_,Objet_gmx),
	typenomsxml_foncteurnomsgmx(Q,R).


%i,i,i,i,o,o
coordonnees_objet(point_f(_),Xpixels,Ypixels,Coord_Xml,[Xr,Yr,1],[-15,-15]) :-
    % si erreur alors c'est que le marqueur de bidouille "Nan" est prsent
	catch(conv_type_coordonnees(Coord_Xml,Xn,Yn),_,fail),
% echelle(Echelle,_),
	Echelle is 37.79527559,
	!,
	Xr is (Xn*Echelle) + (Xpixels / 2),
	Yr is ((Yn * Echelle) - (Ypixels / 2))* -1 .

coordonnees_objet(_,_,_,_,[],[]).


conv_type_coordonnees([element(homogeneous_coordinates,_,[_,_,element(_,_,[I])])],_,_):-
	atom_number(I,In),
	In = 0.0,
	!,
	fail.
conv_type_coordonnees([element(Type,_,[element(double,_,[Xa]),element(double,_,[Ya])|_])],  Xr,Yr):-
       atom_number(Xa,Xn),
       atom_number(Ya,Yn),
% provisoire (ne traite pas les complexes pour l'instant)
       (
           memberchk(Type,[euclidean_coordinates,homogeneous_coordinates]),
           Xr = Xn, Yr = Yn,
	   !
       ;
          Type =polar_coordinates,
          Xr is Xn * cos(Yn),
          Yr is Xn * sin(Yn)
       ),
       !.


%  partir du typage et du nom ds xml fournit le foncteur(nom) geometrix
% ex : point,id=A  >> point_f("A")
% i,i,o,o

type_geometrix(Type,Id_Nom,NomAtomique,FoncteurNomGmx) :-
		exprxml_vers_chgmx(Id_Nom,N,NomAtomique),
		type_geometrix_b(Type,N,FoncteurNomGmx).

type_geometrix_b(Type,N,point_f(N)) :-
	memberchk(Type,[point,point_f]),
	!.
type_geometrix_b(point1,N,point1(N)) :-	!.
type_geometrix_b(D,N,droite_f(Dr)) :-
	memberchk(D,[line,droite_f]),
	lst_str(["(",N,")"],"",Dr),
	!.
type_geometrix_b(Type,N,segment_f(Sg)) :-
	memberchk(Type,[line_segment,segment_f]),
	lst_str(["[",N,"]"],"",Sg),
	!.
type_geometrix_b(Cr,N,cercle_f(N)) :-
	memberchk(Cr,[circle,cercle_f]),
	!.
type_geometrix_b(V,N,vecteur_f(N)) :-
	memberchk(V,[vector,vecteur_f]),
	!.
type_geometrix_b(V,N,polygone_f(N)) :-
	memberchk(V,[polygon,polygone_f]),
	!.
type_geometrix_b(V,N,demidroite_f(N)) :-
	memberchk(V,[ray,demidroite_f]),
	!.
type_geometrix_b(ch,N,ch(N)) :-!.
type_geometrix_b(double,N,num(Nb)) :-
	atom_number(N,Nb).



%i,O,O
% traduction contrainte  geometrie dynamique --> relation logique code Geometrix
contraintexml_codegmx(free_point,2,1) :-!.
contraintexml_codegmx(point_on_line,2,8) :-!. % traiter un nb dans les reconstructeurs ( faire)
contraintexml_codegmx(line_segment_by_points,3,1) :-!.
contraintexml_codegmx(point_on_circle,2,10) :-!.
contraintexml_codegmx(midpoint_line_segment,2,3) :-!.
contraintexml_codegmx(polygon_by_vertices,4,13):-!.

contraintexml_codegmx(point_on_line_segment,2,25) :-!.
contraintexml_codegmx(midpoint_of_two_points,2,3) :-!.
contraintexml_codegmx(line_through_two_points,3,2) :-!.
contraintexml_codegmx(point_intersection_of_two_lines,2,4) :-!.
contraintexml_codegmx(line_parallel_to_line_through_point,3,3) :-!.
contraintexml_codegmx(circle_tangent_lines_by_point,3,9) :-!.
contraintexml_codegmx(circle_by_center_and_point,4,10) :-!.
contraintexml_codegmx(line_perpendicular_to_line_through_point,3,4) :-!.
contraintexml_codegmx(intersection_points_of_two_circles,2,6) :-!.
contraintexml_codegmx(intersection_points_of_circle_and_line,2,5) :-!.
contraintexml_codegmx(center_of_circle,2,11) :-!.
contraintexml_codegmx(circle_by_three_points,4,8) :-!.
contraintexml_codegmx(line_angular_bisector_of_three_points,4,4) :-!.
contraintexml_codegmx(vector_from_point_to_point,6,1) :-!.
contraintexml_codegmx(ray_from_point_through_point,3,11):-!.
contraintexml_codegmx(polygon_by_vertices,3,4):-!.
contraintexml_codegmx(symmetry_by_point,5,2):-!.
contraintexml_codegmx(symmetry_by_line,5,3):-!.
contraintexml_codegmx(translate,5,1):-!.



%fig_4(point_f("P1"), [16777215, 0], [-15, -15], "d", [436.409, 487.795, 1], [point_f("P"), point_f("C")], "", [7, 5, 2], [point_f("P"), point_f("C")]).

%contraintexml_codegmx
%
%
% codage objet geometrix (x,y), "arguments" xml(le 1er est le nom de l'objet cr), Parents, Constructeurs
%i,i,i,o,o

parents_et_constructeurs(2,8,[_,Droite,Num],[Droite],[Droite,ch(""),Num]) :-!.
parents_et_constructeurs(2,6,[point_f(P1),_,C1,C2],[C1,C2],[C1,C2,ch("1"),point_f(P1),point_f(P1)]) :-!.
parents_et_constructeurs(2,6,[point1(P1),P2,C1,C2],[C1,C2],[C1,C2,ch("2"),point_f(P1),P2]) :-!.
parents_et_constructeurs(2,5,[_,_,C1,Dr],[C1,Dr],[Dr,C1,ch("1")]) :-!.
parents_et_constructeurs(2,5,[P1,C1,Dr],[C1,Dr],[Dr,C1,ch("2"),P1]) :-!.
% cercle circonscrit
parents_et_constructeurs(4,8,[point_f(A),point_f(B),point_f(C)],[triangle_f(ABC)],[triangle_f(ABC),ch("")]):-
	!,
	msort([A,B,C],LABC),
	lst_str(LABC,"",ABC).
% bissectrice 3pts
parents_et_constructeurs(4,4,[_|Points],Points,Points) :- !.
% vecteur 2 pts
parents_et_constructeurs(6,1,[_|Points],Points,Points) :- !.
%demi droite 2 pts
parents_et_constructeurs(3,11,[_|Points],Points,Points) :- !.

parents_et_constructeurs(2,11,[_,Cercle],[Cercle],[Cercle,ch("")]) :-!.
parents_et_constructeurs(2,10,[_,Cercle],[Cercle],[]) :-!.

% tangente
parents_et_constructeurs(3,9,[Point,Cercle,Ch,D1,D2],[Point,Cercle],[Point, Cercle,Ch,D1,D2]) :-!.
% les autres
parents_et_constructeurs(_,_,[_|Q],Q,Q) :-!.
parents_et_constructeurs(_,_,L,L,L) :-!.



%i,o,o  exemple id=A  --> "A" (type string)   et A (type atomique)
exprxml_vers_chgmx(Id_N,Nom,NomAtome) :-
	term_to_atom(Id_N,Atome_expr),
	concat_atom([_,Nom_Atome],=,Atome_expr),
	!,
% aprs lecture du fichier xml les noms d'objets en MAJ ont t mises entre apostrophes, faut les enlever
	atom_codes(Nom_Atome,Lst_char),
	supp_entre_apostrophes(Lst_char,Lchar),
	string_to_list(Nom,Lchar),
	atom_chars(NomAtome,Lchar).
exprxml_vers_chgmx(Id_N,Nom,NomAtome) :-
	atom_codes(Id_N,Lst_char),
	supp_entre_apostrophes(Lst_char,Lchar),
	string_to_list(Nom,Lchar),
	atom_chars(NomAtome,Lchar).

/*


fig_4(segment_f("[AB]"), [16777215, 0], [], "d", [436.409, 450.0, 474.205, 450.0], [point_f("A"), point_f("B")], "", [3, 3, 1], [point_f("A"), point_f("B")]).
fig_4(vecteur_f("v"), [16777215, 0], [], "d", [549.795, 450.0, 37.796, -37.795], [point_f("P"), point_f("Q")], "", [4, 6, 1], [point_f("P"), point_f("Q")]).
fig_4(point_f("A1"), [16777215, 0], [-15, -15], "d", [474.205, 412.205, 1], [point_f("A"), vecteur_f("v")], "", [8, 5, 1], [point_f("A"), vecteur_f("v")]).
fig_4(point_f("B1"), [16777215, 0], [-15, -15], "d", [512.001, 412.205, 1], [point_f("B"), vecteur_f("v")], "", [9, 5, 1], [point_f("B"), vecteur_f("v")]).
fig_4(segment_f("[A1B1]"), [16777215, 0], [], "d", [474.205, 412.205, 512.001, 412.205], [point_f("A1"), point_f("B1")], "", [10, 3, 1], [point_f("A1"), point_f("B1")]).
fig_4(droite_f("(A1B1)"), [16777215, 0], [], "n", [0.0, 412.205, 1842.0, 412.205, 0, 412.205, 1.0, 0.0], [point_f("A1"), point_f("B1")], "", [11, 3, 2], [point_f("A1"), point_f("B1")]).


*/

corrige_incoherence_i2g(fig_4(Cercle,A,B,C,D,[triangle_f(PQR)],E,[Num,4,8],G),
                        fig_4(Cercle,A,B,C,D,[triangle_f(PQR)],E,[Index2,4,8],G)) :-
	supp_guillemets(PQR,Atome_PQR),
	string_to_atom(PQR_ch,Atome_PQR),
	isoleNomsDesPoints(PQR_ch,[P,Q,R]),
	applicationFoncteurs(point_f(_),[P,Q,R],Sommets),
	numerotation_objet(Index),
	Index2 is Index+1,
        assert(fig_4(triangle_f(PQR),[16777215,0],[],"n",[],Sommets,E,[Num,4,1],Sommets)),
	!.
corrige_incoherence_i2g(fig_4(polygone_f(_), A,B,C,D, Sommets, E, [Num,4,13], F),
                        fig_4(polygone_f(NomPoly), A,B,C,D, Sommets, E, [Num,4,13], F)) :-
	findall(P,
		member(point_f(P),Sommets),
		LesPoints),
        lst_str(LesPoints,"",NomPoly),
	!.
% fig_4(segment_f([s2]), [16777215, 0], [], d, [], [point_f(P2),
% point_f(Q2)], , [7, 5, 2], [point_f(P2), point_f(Q2)]),
% les symtries centrales et axiales
corrige_incoherence_i2g(fig_4(segment_f(_), A,B,C,D, _, E, [Num,5,Type_sym], [P1,P2]),
                        fig_4(segment_f(Seg), A,B,C,D, [point_f(Pt1),point_f(Pt2)], E, [Num,3,1], [point_f(Pt1),point_f(Pt2)])) :-
        memberchk(Type_sym,[1,2,3]),
        msort([P1,P2],[point_f(Pt1),point_f(Pt2)]),
        lst_str(["[",Pt1,Pt2,"]"],"",Seg),
	!.
corrige_incoherence_i2g(fig_4(Foncteur, A,B,C,D,[point_f(A1), point_f(B1)],E,F,G),
		 fig_4(Foncteur_s, A,B,C,D,[point_f(A1), point_f(B1)], E,F,G)) :-
	memberchk(Foncteur,[segment_f(_),demidroite_f(_)]),
        msort([A1,B1],LAB),
	lst_str(LAB,"",AB),
	supp_guillemets(AB,Atome_AB),
     (	Foncteur=segment_f(_),
	l_concat(["[",Atome_AB,"]"],"",Sg),
	Foncteur_s=segment_f(Sg)
     ;
        Foncteur=demidroite_f(_),
	l_concat(["[",Atome_AB,")"],"",Sg),
	Foncteur_s=demidroite_f(Sg)
     ),
        !.



corrige_incoherence_i2g(I,I).

%fig_4(point_f("A"), [16777215, 0], [-15, -15], "d", [549.795, 412.205, 1], [cercle_f("c")], "", [5, 2, 10], []).
repositionne_point_sur(fig_4(P,A,B,C,[Xp,Yp,Poids],[Cercle],F,[Num,2,10],_)):-
	fig_4(Cercle,_,_,_,[Xa1,Ya1,Xo1,Yo1,R1],_,_,_,_),
	equation_droite(Xp,Yp,Xo1,Yo1,DX1,DY1,DX2,DY2,Coefd,Bd,Vxd,Vyd),
	inter_droite_cercle(Coefd,Bd,Vxd,Vyd,[DX1,DY1,DX2,DY2],Xo1,Yo1,R1,S),
	le_plus_proche(Xp,Yp,S,XP1,YP1),
	dessin_angle(Xo1,Yo1,XP1,YP1,Xa1,Ya1,Deg,_),
	vecteur_def(Xa1,Ya1,Xo1,Yo1,VA,VB),
	vecteur_def(Xa1,Ya1,XP1,YP1,VC,VD),
	Det is (VA*VD)-(VB*VC),
	signe(Det,0,Sens_rotat),
	retract(fig_4(P,_,_,_,_,_,_,_,_)),
	assert(fig_4(P,A,B,C,[Xp,Yp,Poids],[Cercle],F,[Num,2,10],[Cercle,num(Deg),numi(Sens_rotat)])),
	!.

repositionne_point_sur(fig_4(point_f(P),A,B,C,[Xp,Yp,Poids],[point_f(P1),point_f(P2)],D,[Index,2,25],_)) :-
	fig_4(point_f(P1), _,_,_, [X1,Y1,_], _,_,_,_),
	fig_4(point_f(P2), _,_,_, [X2,Y2,_], _,_,_,_),
	equation_droite(X1,Y1,X2,Y2,_,_,_,_,Coefd,Bd,Vxd,Vyd),
	projection_orthogonale(Xp,Yp,Vxd,Vyd,Coefd,Bd,[X1,Y1,X2,Y2],Xr,Yr),
	pointAppseg(X1,Y1,X2,Y2,Xr,Yr),
	sidiffzero([X1,Y1],[X2,Y2],Xr,Yr,Beta),
	cree_droite([point_f(P1),point_f(P2)],_),
	retract(fig_4(point_f(P),_,_,_,_,_,_,_,_)),
	lst_str(["(",P1,P2,")"],"",Dr),
	assert(fig_4(point_f(P),A,B,C,[Xp,Yp,Poids],[droite_f(Dr)],D,[Index,2,25],[droite_f(Dr),num(Beta)])),
	!.



ordonne_indexage :-
	findall(X,fig_4(X, _,_,_,_,_,_,_,_),LX),
	member(Obj,LX),
	tradFoncteurVersChaine(Obj,T,O),
	remontelepluspossible(T,O),
	fail.
ordonne_indexage.



% ------------------------ bibliothque locale ---------------------------------------
% supp apostrophes  si en dbut ET fin de liste
supp_entre_apostrophes([39|Q],S):-
	append(S,[39],Q),
	!.
supp_entre_apostrophes(I,I).




l_concat([T1|Q],Accu,R) :-
	string_concat(Accu,T1,S1),
	!,
	l_concat(Q,S1,R).
l_concat([],Accu,Accu).

supp_guillemets(T,S):-
	term_to_atom(T,Atome),
	atom_codes(Atome,Lst_char),
	delete(Lst_char,34,Lchar),
	string_to_list(S,Lchar).













